<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class BlackjackSession extends Migration
{
    public function up() {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'user_id' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'deck' => [
                'type' => 'JSON',
            ],
            'player_hand' => [
                'type' => 'JSON',
            ],
            'dealer_hand' => [
                'type' => 'JSON',
            ],
        ]);
        $this->forge->addKey('id', TRUE);
        $this->forge->createTable('blackjack_session');
    }

    public function down()
    {
        $this->forge->dropTable('blackjack_session');
    }
}
